using System;

//dla ICompare
using System.Collections;

namespace Reversi
{
	/// <summary>
	/// Opis klasy ReversiSilnik.
	/// </summary>
	public class ReversiSilnik
	{
		public const int planszaSzer=8;
		public const int planszaWys=8;
		private byte[,] plansza=new byte[planszaSzer,planszaWys];
		private byte nrGraczaWykonujacegoNastepnyRuch=1;

		public ReversiSilnik()
		{
			for (int i=0; i<planszaSzer; i++)
				for (int j=0; j<planszaWys; j++)
					plansza[i,j]=0;
			plansza[3,3]=1;
			plansza[4,4]=1;
			plansza[3,4]=2;
			plansza[4,3]=2;
		}

		public byte StanPola(int poziomo,int pionowo)
		{
			if (poziomo<0 || poziomo>=planszaSzer || pionowo<0 || pionowo>=planszaWys)
				throw new Exception("Nieprawidowe wsprzdne pola");
			return plansza[poziomo,pionowo];
		}

		public byte NumerGraczaWykonujacegoNastepnyRuch()
		{
			return nrGraczaWykonujacegoNastepnyRuch;
		}

		public static string SymbolPola(int poziomo,int pionowo)
		{
			if (poziomo>25 || pionowo>8) return "("+poziomo.ToString()+","+pionowo.ToString()+")";
			return ""+"ABCDEFGHIJKLMNOPQRSTUVWXYZ"[poziomo]+"123456789"[pionowo];
		}

		private bool UstawPionek(int poziomo,int pionowo,bool testowanie)
		{
			//czy prawidlowe wspolrzedne
			if (poziomo<0 || poziomo>=planszaSzer || pionowo<0 || pionowo>=planszaWys)
				throw new Exception("Nieprawidowe wsprzdne pola");

			//czy pole nie jest juz zajete?
			if (plansza[poziomo,pionowo]!=0) return false;

			bool poprawnyRuch=false;

			//petla po 8 kierunkach
			for (int kierunekPoziomo=-1; kierunekPoziomo<=1; kierunekPoziomo++)
			for (int kierunekPionowo=-1; kierunekPionowo<=1; kierunekPionowo++)
				{
				//wymuszenie pominiecia przypadku gdy obie zmienne rowne 0
				if (kierunekPoziomo==0 && kierunekPionowo==0) continue;
				//szukanie pionkow gracza w jednym z 8 kierunkow
				int szukajPoziomo=poziomo;
				int szukajPionowo=pionowo;
				bool znalezionyPionekPrzeciwnika=false;
				bool znalezionyPionekGraczaWykonujacegoRuch=false;
				bool znalezionePustePole=false;
				bool osiagnietaKrawedzPlanszy=false;
				do
					{
					szukajPoziomo+=kierunekPoziomo;
					szukajPionowo+=kierunekPionowo;
					osiagnietaKrawedzPlanszy=(szukajPoziomo<0 || szukajPionowo<0 || szukajPoziomo>=planszaSzer || szukajPionowo>=planszaWys);
					if (!osiagnietaKrawedzPlanszy)
						{
						znalezionyPionekGraczaWykonujacegoRuch=(plansza[szukajPoziomo,szukajPionowo]==nrGraczaWykonujacegoNastepnyRuch);
						if (!znalezionePustePole) znalezionePustePole=(plansza[szukajPoziomo,szukajPionowo]==0);
						if (!znalezionyPionekPrzeciwnika) znalezionyPionekPrzeciwnika=(plansza[szukajPoziomo,szukajPionowo]==((nrGraczaWykonujacegoNastepnyRuch==1)?2:1));
						}
					}
				while(!(osiagnietaKrawedzPlanszy || znalezionyPionekGraczaWykonujacegoRuch));

				//sprawdzenie warunku poprawnosci ruchu
				bool znalezione=(znalezionyPionekPrzeciwnika && znalezionyPionekGraczaWykonujacegoRuch && !znalezionePustePole);

				//odwrocenie pionkow w przypadku spelnionego warunku
				if (znalezione)
					{
					if (!testowanie)
						{
						int maks_indeks=Math.Max(Math.Abs(szukajPoziomo-poziomo),Math.Abs(szukajPionowo-pionowo));
						for(int indeks=0;indeks<maks_indeks;indeks++)
						plansza[poziomo+indeks*kierunekPoziomo,pionowo+indeks*kierunekPionowo]=nrGraczaWykonujacegoNastepnyRuch;
						}
					poprawnyRuch=true;
					}

				} //koniec petli po kierunkach

			//jezeli ruch zostal wykonany - zmiana gracza
			if (poprawnyRuch && !testowanie) nrGraczaWykonujacegoNastepnyRuch=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);

			return poprawnyRuch;
		}

		public bool UstawPionek(int poziomo,int pionowo)
		{
			return UstawPionek(poziomo,pionowo,false);
		}


		public bool CzyMozliwyRuch()
		{
			int iloscPolPoprawnych=0;
			for(int poziomo=0;poziomo<planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<planszaWys;pionowo++)
					if (plansza[poziomo,pionowo]==0)
						if (UstawPionek(poziomo,pionowo,true))
							iloscPolPoprawnych++;

			return iloscPolPoprawnych>0;
		}

		public void Pass()
		{
			nrGraczaWykonujacegoNastepnyRuch=(byte)((nrGraczaWykonujacegoNastepnyRuch==1)?2:1);
		}

		private bool czyPat()
		{
			bool mozliwyRuchGracza1=CzyMozliwyRuch();
			Pass(); //zmiana gracza
			bool mozliwyRuchGracza2=CzyMozliwyRuch();
			Pass(); //powrot do wlasciwego gracza
			return (!mozliwyRuchGracza1 && !mozliwyRuchGracza2);
		}

		private bool czyWszystkiePolaZajete(int[] zliczenia)
		{
			if (zliczenia==null) zliczenia=new int[3];
			for(int poziomo=0;poziomo<planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<planszaWys;pionowo++)
					zliczenia[plansza[poziomo,pionowo]]++;

			return zliczenia[0]==0;
		}

		public int CzyKoniec(int[] zliczenia)
		{

			int kod=czyPat()?2:0;
			kod=(czyWszystkiePolaZajete(zliczenia))?1:kod;
			return kod;
		}

		public byte this[int poziomo,int pionowo]
		{
			get
			{
				return StanPola(poziomo,pionowo);
			}

			set
			{
				UstawPionek(poziomo,pionowo);
			}
		}
	}
}
